dofile(LockOn_Options.common_script_path..'Radio.lua')
dofile(LockOn_Options.common_script_path.."mission_prepare.lua")

local gettext = require("i_18n")
_ = gettext.translate

device_timer_dt = 0.2

innerNoise 			= getInnerNoise(2.5E-6, 10.0)--V/m (dB S+N/N)
frequency_accuracy 	= 500.0				--Hz
band_width			= 12E3				--Hz (6 dB selectivity)
power 				= 10.0				--Watts

agr = {
	input_signal_deviation		= rangeUtoDb(4E-6, 0.5), --Db
	output_signal_deviation		= 5 - (-4),  --Db
	input_signal_linear_zone 	= 10.0, --Db
	regulation_time				= 0.25, --sec
}

GUI = {
	range = {min = 225E6, max = 399.975E6, step = 25E3}, --Hz
	displayName = _('UHF ARC-159'),
	AM = true,
	FM = false
}

-- UHF ARC-159
-- min 225 MHz
-- max 399.975 MHz

-- 255 = 255.000
-- 255.25 = 255.250
-- 255.5 = 255.500
-- 255.75 = 255.750
-- 255.475 = 255.475

presets = {
    [1] = 250,
    [2] = 250.025,
    [3] = 250.05,
    [4] = 250.075,
    [5] = 250.1,
    [6] = 251,
    [7] = 257,
    [8] = 253,
    [9] = 254,
    [10] = 264,
    [11] = 266,
    [12] = 265,
    [13] = 252,
    [14] = 261,
    [15] = 256,
    [16] = 268,
    [17] = 258,
    [18] = 267,
    [19] = 269,
    [20] = 261,
}

  for i = 1,20 do
      presets[i] = presets[i] * 1e6
  end

--goniometer = {isLagElement = true, T1 = 0.3, bias = {{valmin = math.rad(0), valmax = math.rad(360), bias = math.rad(1)}}}

UHF_ARC_159_FAILURE_TOTAL = 0
UHF_ARC_159_FAILURE_DISPLAY = 1
UHF_ARC_159_FAILURE_REMOTE_DISPLAY = 2
UHF_ARC_159_FAILURE_REMOTE_DISPLAY_RIO = 3
UHF_ARC_159_FAILURE_INTERNAL_MODULE = 4
UHF_ARC_159_FAILURE_TRANSCEIVER = 5
UHF_ARC_159_FAILURE_ANTENNA = 6

Damage = { {Failure = UHF_ARC_159_FAILURE_TOTAL, Failure_name = "UHF_ARC_159_FAILURE_TOTAL", Failure_editor_name = _("UHF AN/ARC-159: Total"), Element = "AVX_WALL_LEFT_REAR", Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = UHF_ARC_159_FAILURE_DISPLAY, Failure_name ="UHF_ARC_159_FAILURE_DISPLAY", Failure_editor_name = _("UHF AN/ARC-159: Display"), Element = "AVX_WALL_LEFT_FRONT", Integrity_Treshold = 0.6, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = UHF_ARC_159_FAILURE_REMOTE_DISPLAY, Failure_name = "UHF_ARC_159_FAILURE_REMOTE_DISPLAY", Failure_editor_name = _("UHF AN/ARC-159: Remote Display Pilot"), Element = "DASHBOARD_PILOT", Integrity_Treshold = 0.8, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = UHF_ARC_159_FAILURE_REMOTE_DISPLAY_RIO, Failure_name = "UHF_ARC_159_FAILURE_REMOTE_DISPLAY_RIO", Failure_editor_name = _("UHF AN/ARC-159: Remote Display RIO"), Element = "DASHBOARD_RIO", Integrity_Treshold = 0.8, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = UHF_ARC_159_FAILURE_INTERNAL_MODULE, Failure_name = "UHF_ARC_159_FAILURE_INTERNAL_MODULE", Failure_editor_name = _("UHF AN/ARC-159: Internal Module"), Element = "AVX_WALL_LEFT_REAR", Integrity_Treshold = 0.25, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = UHF_ARC_159_FAILURE_TRANSCEIVER, Failure_name = "UHF_ARC_159_FAILURE_TRANSCEIVER", Failure_editor_name = _("UHF AN/ARC-159: Transceiver"), Element = "AVX_WALL_LEFT_REAR", Integrity_Treshold = 0.25, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = UHF_ARC_159_FAILURE_ANTENNA, Failure_name = "UHF_ARC_159_FAILURE_ANTENNA", Failure_editor_name = _("UHF AN/ARC-159: Antenna"), Element = "UHF_IFF", Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250}
}

need_to_be_closed = true -- close lua state after initialization 
